/**************************************************
 *
 * Part one of the system initialization code, contains low-level
 * initialization, plain thumb variant.
 *
 * Copyright 2008 IAR Systems. All rights reserved.
 *
 * $Revision: 26559 $
 *
 **************************************************/

;
; The modules in this file are included in the libraries, and may be replaced
; by any user-defined modules that define the PUBLIC symbol _program_start or
; a user defined start symbol.
; To override the cstartup defined in the library, simply add your modified
; version to the workbench project.
;
; The vector table is normally located at address 0.
; When debugging in RAM, it can be located in RAM, aligned to at least 2^6.
; The name "__vector_table" has special meaning for C-SPY:
; it is where the SP start value is found, and the NVIC vector
; table register (VTOR) is initialized to this address if != 0.
;
; Cortex-M version
;

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        PUBLIC  __vector_table
        PUBLIC  __vector_table_0x1c

        DATA
__vector_table
        DCD     sfe(CSTACK)
        DCD     __iar_program_start

        DCD     NMI_Handler
        DCD     HardFault_Handler
        DCD     MemManage_Handler
        DCD     BusFault_Handler
        DCD     UsageFault_Handler
__vector_table_0x1c
        DCD     0
        DCD     0
        DCD     0
        DCD     0
        DCD     SVC_Handler
        DCD     DebugMon_Handler
        DCD     0
        DCD     PendSV_Handler
        DCD     SysTick_Handler
        DCD     IntDefaultHandler         // 16 WDT
        DCD     IntDefaultHandler         // 17 TIMER0
        DCD     IntDefaultHandler         // 18 TIMER1
        DCD     IntDefaultHandler         // 19 TIMER2
        DCD     IntDefaultHandler         // 20 TIMER3
        DCD     IntDefaultHandler         // 21 UART0
        DCD     IntDefaultHandler         // 22 UART1
        DCD     IntDefaultHandler         // 23 UART2
        DCD     IntDefaultHandler         // 24 UART3
        DCD     IntDefaultHandler         // 25 PWM1
        DCD     IntDefaultHandler         // 26 I2C0
        DCD     IntDefaultHandler         // 27 I2C1
        DCD     IntDefaultHandler         // 28 I2C2
        DCD     IntDefaultHandler         // 29 SPI
        DCD     IntDefaultHandler         // 30 SSP0
        DCD     IntDefaultHandler         // 31 SSP1
        DCD     IntDefaultHandler         // 32 PLL0
        DCD     IntDefaultHandler         // 33 RTC
        DCD     IntDefaultHandler         // 34 EINT0
        DCD     IntDefaultHandler         // 35 EINT1
        DCD     IntDefaultHandler         // 36 EINT2
        DCD     IntDefaultHandler         // 37 EINT3
        DCD     IntDefaultHandler         // 38 ADC
        DCD     IntDefaultHandler         // 39 BOD
        DCD     IntDefaultHandler         // 40 USB
        DCD     IntDefaultHandler         // 41 CAN
        DCD     IntDefaultHandler         // 42 GP DMA
        DCD     IntDefaultHandler         // 43 I2S
        DCD     IntDefaultHandler         // 44 Ethernet
        DCD     IntDefaultHandler         // 45 Repetitive Interrupt Timer
        DCD     IntDefaultHandler         // 46 Motor Control PWM
        DCD     IntDefaultHandler         // 47 Quadrature Encoder
        DCD     IntDefaultHandler         // 48 PLL1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK NMI_Handler
        SECTION .text:CODE:REORDER(1)
NMI_Handler
        B NMI_Handler
        PUBWEAK HardFault_Handler
        SECTION .text:CODE:REORDER(1)
HardFault_Handler
        B HardFault_Handler
        PUBWEAK MemManage_Handler
        SECTION .text:CODE:REORDER(1)
MemManage_Handler
        B MemManage_Handler
        PUBWEAK BusFault_Handler
        SECTION .text:CODE:REORDER(1)
BusFault_Handler
        B BusFault_Handler
        PUBWEAK UsageFault_Handler
        SECTION .text:CODE:REORDER(1)
UsageFault_Handler
        B UsageFault_Handler
        PUBWEAK SVC_Handler
        SECTION .text:CODE:REORDER(1)
SVC_Handler
        B SVC_Handler
        PUBWEAK DebugMon_Handler
        SECTION .text:CODE:REORDER(1)
DebugMon_Handler
        B DebugMon_Handler
        PUBWEAK PendSV_Handler
        SECTION .text:CODE:REORDER(1)
PendSV_Handler
        B PendSV_Handler
        PUBWEAK SysTick_Handler
        SECTION .text:CODE:REORDER(1)
SysTick_Handler
        B SysTick_Handler
        PUBWEAK IntDefaultHandler
        SECTION .text:CODE:REORDER(1)
IntDefaultHandler
        B IntDefaultHandler

        END
